#ifndef __DEV_INTERFACE_USER_H_
#define __DEV_INTERFACE_USER_H_

#ifdef __cplusplus
extern "C"
{
#endif

/* ============================================================================= */
/* User defined helper functions                                                 */
/* ============================================================================= */


/* ============================================================================= */
/* examples for general device functions                                         */
/* need to be adapted according to platform, OS, ... or other specific needs     */
/* ============================================================================= */
int32_t DEV_Initialize            ( PDEVICEINSTANCE ptDevInst, uint32_t ulCommChannelCount);
void    DEV_Uninitialize          ( PDEVICEINSTANCE ptDevInst);

void    DEV_InitializeInterrupt   ( PDEVICEINSTANCE ptDevInst);
void    DEV_UninitializeInterrupt ( PDEVICEINSTANCE ptDevInst);


int32_t DEV_ProcessWarmstart      ( CHANNELINSTANCE* ptChannel, CIFX_PACKET* ptSendPacket);
int32_t DEV_DeleteConfig          ( CHANNELINSTANCE* ptChannel);

#ifdef __cplusplus
}
#endif

#endif /* __DEV_INTERFACE_USER_H_ */